function onCreate()
	--Iterate over all notes
	for i = 0, getProperty('unspawnNotes.length')-1 do
		if getPropertyFromGroup('unspawnNotes', i, 'noteType') == 'food' then --Check if the note on the chart is a Bullet Note
			setPropertyFromGroup('unspawnNotes', i, 'texture', 'food'); --Change texture
			setPropertyFromGroup('unspawnNotes', i, 'noteSplashHue', 128); --custom notesplash color, why not
			setPropertyFromGroup('unspawnNotes', i, 'noteSplashSat', 122);
			setPropertyFromGroup('unspawnNotes', i, 'noteSplashBrt', 86);

			if getPropertyFromGroup('unspawnNotes', i, 'mustPress') then --Doesn't let Dad/Opponent notes get ignored
				setPropertyFromGroup('unspawnNotes', i, 'ignoreNote', true); --Miss has penalties
			end
		end
	end
end

function goodNoteHit(id, direction, noteType, isSustainNote)
	if noteType == 'food' then
		characterPlayAnim('boyfriend', '', false);
		characterPlayAnim('dad', '', false);
		setProperty('boyfriend.specialAnim', false);
		setProperty('dad.specialAnim', false);
		cameraShake('camGame', 0, 0)
    end
end

function noteMiss(id, direction, noteType, isSustainNote)
	if noteType == 'food' then
		setProperty('health', getProperty('health'));
		characterPlayAnim('boyfriend', 'idle', false);
	elseif noteType == 'food' and difficulty == 1 then
		setProperty('health', getProperty('health')-0.3);
		playSound('', 0.8);
		characterPlayAnim('boyfriend', 'idle', true);
	end
end

function onTimerCompleted(tag, loops, loopsLeft)
	-- A loop from a timer you called has been completed, value "tag" is it's tag
	-- loops = how many loops it will have done when it ends completely
	-- loopsLeft = how many are remaining
	if loopsLeft >= 1 then
		setProperty('health', getProperty('health')-0.001);
	end
end